<?php
include '../includes/auth.php';
include '../includes/db.php';

$judge_id = $_SESSION['judge_id'];

// Ensure the user is a head judge
$is_head_stmt = $pdo->prepare("SELECT is_head FROM judges WHERE id = ?");
$is_head_stmt->execute([$judge_id]);
$is_head = $is_head_stmt->fetchColumn();

if (!$is_head) {
    die('<div class="alert alert-danger">Access denied: Not a head judge.</div>');
}

// Handle override form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['score_id'])) {
    $score_id = $_POST['score_id'];
    $new_score = $_POST['score_value'] !== '' ? floatval($_POST['score_value']) : null;
    $status = $_POST['status'];

    $update_stmt = $pdo->prepare("UPDATE scores SET score_value = ?, status = ? WHERE id = ?");
    $update_stmt->execute([$new_score, $status, $score_id]);
}

// Fetch scores for current events assigned to this head judge
$scores_stmt = $pdo->prepare("
    SELECT s.id AS score_id, e.name AS event_name,
           p.first_name, p.last_name, ep.bib_number as bib,
           r.run_number, s.score_value, s.status, j.name AS judge_name,
           ep.heat_number
    FROM scores s
    JOIN runs r ON s.run_id = r.id
    JOIN event_participants ep ON r.event_participant_id = ep.id
    JOIN participants p ON ep.participant_id = p.id
    JOIN events e ON ep.event_id = e.id
    JOIN judges j ON s.judge_id = j.id
    JOIN judge_assignments ja ON e.id = ja.event_id
    WHERE ja.judge_id = ?
    ORDER BY s.created_at DESC
");
$scores_stmt->execute([$judge_id]);
$scores = $scores_stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Head Judge Panel</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<!-- style skin holder -->
</head>
<body class="body-bg-aurora-bright">
    <?php include '../menu.php'; ?>
<div class="container-fluid mt-4">
    <h2>Head Judge Panel</h2>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Event</th>
                <th>Participant</th>
                <th>Heat</th>
                <th>Run</th>
                <th>Judge</th>
                <th>Score</th>
                <th>Status</th>
                <th>Override</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($scores as $score): ?>
            <tr>
                <td><?= htmlspecialchars($score['event_name']) ?></td>
                <td>
                     (<?= htmlspecialchars($score['bib']) ?>)
        <?= htmlspecialchars($score['first_name']) ?>
        <?= htmlspecialchars($score['last_name']) ?>
       
    </td>
    <td><?= htmlspecialchars($score['heat_number']) ?></td>
                <td><?= $score['run_number'] ?></td>
                <td><?= htmlspecialchars($score['judge_name']) ?></td>
                <td><?= $score['score_value'] ?></td>
                <td><?= $score['status'] ?></td>
                <td>
                    <form method="post" class="d-flex flex-wrap gap-1">
                        <input type="hidden" name="score_id" value="<?= $score['score_id'] ?>">
                        <input type="number" name="score_value" class="form-control form-control-sm" style="width:90px" min="0" max="99" step="1" value="<?= $score['score_value'] ?>">
                        <select name="status" class="form-select form-select-sm" style="width:100px">
                            <option value="OK" <?= $score['status'] == 'OK' ? 'selected' : '' ?>>OK</option>
                            <option value="DNS" <?= $score['status'] == 'DNS' ? 'selected' : '' ?>>DNS</option>
                            <option value="DNF" <?= $score['status'] == 'DNF' ? 'selected' : '' ?>>DNF</option>
                            <option value="DSQ" <?= $score['status'] == 'DSQ' ? 'selected' : '' ?>>DSQ</option>
                        </select>
                        <button type="submit" class="btn btn-sm btn-warning">Update</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
